﻿using Microscopic_Traffic_Simulator___Model.TrafficObjects;
using System.Windows;

namespace Microscopic_Traffic_Simulator___Model.CellularTopologyObjects
{
    /// <summary>
    /// Class representing cell.
    /// </summary>
    public class Cell
    {
        /// <summary>
        /// Location of cell.
        /// </summary>
        private Point location;
        /// <summary>
        /// Location of cell.
        /// </summary>
        public Point Location { get { return location; } }

        /// <summary>
        /// Normalized direction vector.
        /// </summary>
        private Vector normalizedDirectionVector;
        /// <summary>
        /// Normalized direction vector.
        /// </summary>
        public Vector NormalizedDirectionVector 
        { 
            get { return normalizedDirectionVector; } set { normalizedDirectionVector = value; } 
        }

        /// <summary>
        /// Car which currently lies on this cell.
        /// </summary>
        private Car car;
        /// <summary>
        /// Car which currently lies on this cell.
        /// </summary>
        internal Car Car { get { return car; } set { car = value; } }

        /// <summary>
        /// Link to previous cell.
        /// </summary>
        private Cell previousCell;
        /// <summary>
        /// Link to previous cell.
        /// </summary>
        public Cell PreviousCell { get { return previousCell; } set { previousCell = value; } }

        /// <summary>
        /// Link to following cell.
        /// </summary>
        private Cell followingCell;
        /// <summary>
        /// Link to following cell.
        /// </summary>
        public Cell FollowingCell { get { return followingCell; } set { followingCell = value; } }

        /// <summary>
        /// Instance to senzor connected to cell if there is any.
        /// </summary>
        private Sensor sensor;
        /// <summary>
        /// Instance to senzor connected to cell if there is any.
        /// </summary>
        internal Sensor Sensor { get { return sensor; } set { sensor = value; } }

        /// <summary>
        /// Cell constructor.
        /// </summary>
        /// <param name="location">Location of cell.</param>
        internal Cell(Point location)
        {
            this.location = location;
        }
    }
}
